/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.concurrent.CompletionStage;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.jboss.resteasy.annotations.providers.img.ImageWriterParams;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.IIOImageProviderHelper;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.util.FindAnnotation;

@Provider
@Consumes(value={"image/*"})
@Produces(value={"image/*"})
public class IIOImageProvider
extends AbstractEntityProvider<IIOImage> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return IIOImage.class.equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIOImage readFrom(Class<IIOImage> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", (Object)this.getClass().getName());
        ImageReader reader = IIOImageProviderHelper.getImageReaderByMediaType(mediaType);
        try {
            IIOImage image;
            IIOImage iIOImage = image = IIOImageProviderHelper.readImage(entityStream, reader, 0);
            return iIOImage;
        }
        finally {
            reader.dispose();
        }
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return IIOImage.class.equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(IIOImage t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)this.getClass().getName());
        ImageWriter writer = IIOImageProviderHelper.getImageWriterByMediaType(mediaType);
        ImageWriteParam param = mediaType.equals(MediaType.valueOf("image/jpeg")) ? new JPEGImageWriteParam(Locale.US) : writer.getDefaultWriteParam();
        ImageWriterParams writerParams = FindAnnotation.findAnnotation(annotations, ImageWriterParams.class);
        if (writerParams != null) {
            if (param.canWriteCompressed()) {
                int cm = writerParams.compressionMode();
                param.setCompressionMode(cm);
                if (2 == cm) {
                    param.setCompressionQuality(writerParams.compressionQuality());
                }
            }
        } else if (param.canWriteCompressed()) {
            param.setCompressionMode(2);
            param.setCompressionQuality(1.0f);
        }
        BufferedOutputStream buff = new BufferedOutputStream(entityStream, 2048);
        ImageOutputStream ios = ImageIO.createImageOutputStream(buff);
        try {
            writer.setOutput(ios);
            IIOImage img = new IIOImage(t.getRenderedImage(), null, null);
            writer.write(null, img, param);
        }
        finally {
            writer.dispose();
        }
    }

    @Override
    public CompletionStage<Void> asyncWriteTo(IIOImage t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)this.getClass().getName());
        ImageWriter writer = IIOImageProviderHelper.getImageWriterByMediaType(mediaType);
        ImageWriteParam param = mediaType.equals(MediaType.valueOf("image/jpeg")) ? new JPEGImageWriteParam(Locale.US) : writer.getDefaultWriteParam();
        ImageWriterParams writerParams = FindAnnotation.findAnnotation(annotations, ImageWriterParams.class);
        if (writerParams != null) {
            if (param.canWriteCompressed()) {
                int cm = writerParams.compressionMode();
                param.setCompressionMode(cm);
                if (2 == cm) {
                    param.setCompressionQuality(writerParams.compressionQuality());
                }
            }
        } else if (param.canWriteCompressed()) {
            param.setCompressionMode(2);
            param.setCompressionQuality(1.0f);
        }
        ByteArrayOutputStream buff = new ByteArrayOutputStream(2048);
        try {
            ImageOutputStream ios = ImageIO.createImageOutputStream(buff);
            writer.setOutput(ios);
            IIOImage img = new IIOImage(t.getRenderedImage(), null, null);
            writer.write(null, img, param);
            return entityStream.asyncWrite(buff.toByteArray()).whenComplete((v, x) -> writer.dispose());
        }
        catch (IOException e) {
            return ProviderHelper.completedException(e);
        }
    }
}

