/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.se;

import jakarta.ws.rs.SeBootstrap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.net.ssl.SSLContext;
import org.jboss.jandex.Index;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedServer;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.util.PortProvider;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ConfigurationOption {
    PROTOCOL("jakarta.ws.rs.SeBootstrap.Protocol", (Object)"HTTP", (Class)String.class){

        @Override
        public void validate(Object value) {
            if (!(value instanceof String)) {
                throw Messages.MESSAGES.invalidProtocol(String.valueOf(value), "HTTP", "HTTPS");
            }
            String protocol = (String)value;
            if (!"HTTP".equalsIgnoreCase(protocol) && !"HTTPS".equalsIgnoreCase(protocol)) {
                throw Messages.MESSAGES.invalidProtocol(protocol, "HTTP", "HTTPS");
            }
        }
    }
    ,
    HOST("jakarta.ws.rs.SeBootstrap.Host", PortProvider.getHost(), String.class),
    PORT("jakarta.ws.rs.SeBootstrap.Port", PortProvider.getPort(), Integer.class),
    ROOT_PATH("jakarta.ws.rs.SeBootstrap.RootPath", "/", String.class),
    SSL_CONTEXT("jakarta.ws.rs.SeBootstrap.SSLContext", null, SSLContext.class),
    SSL_CLIENT_AUTHENTICATION("jakarta.ws.rs.SeBootstrap.SSLClientAuthentication", (Object)((Object)SeBootstrap.Configuration.SSLClientAuthentication.NONE), SeBootstrap.Configuration.SSLClientAuthentication.class),
    EMBEDDED_SERVER("org.jboss.resteasy.se.embedded.server.instance", null, EmbeddedServer.class),
    JANDEX_INDEX("org.jboss.resteasy.jandex.index", null, Index.class),
    JANDEX_CLASS_PATH_FILTER("org.jboss.resteasy.jandex.filter", null, Predicate.class),
    REGISTER_BUILT_INS("resteasy.use.builtin.providers", true, Boolean.class);

    private static final Map<String, ConfigurationOption> LOOKUP;
    private final String name;
    private final Object value;
    private final Class<?> expectedType;

    private ConfigurationOption(String name, Object value, Class<?> expectedType) {
        this.name = name;
        this.value = value;
        this.expectedType = expectedType;
    }

    public static ConfigurationOption of(String key) {
        return LOOKUP.get(key);
    }

    public <T> T getValue(SeBootstrap.Configuration configuration) {
        if (configuration.hasProperty(this.name)) {
            return (T)configuration.property(this.name);
        }
        return (T)this.value;
    }

    public String key() {
        return this.name;
    }

    public <T> T defaultValue() {
        return (T)this.expectedType.cast(this.value);
    }

    public <T> Class<? extends T> expectedType() {
        return this.expectedType;
    }

    public void validate(Object value) {
        if (!this.expectedType.isInstance(value)) {
            throw Messages.MESSAGES.invalidArgumentType(this.name, value, this.expectedType);
        }
    }

    public String toString() {
        return this.name;
    }

    static {
        LOOKUP = new HashMap<String, ConfigurationOption>();
        for (ConfigurationOption o : ConfigurationOption.values()) {
            LOOKUP.put(o.key(), o);
        }
    }
}

