/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.jboss.resteasy.client.jaxrs.PublisherRxInvoker;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.reactivestreams.Publisher;

public abstract class PublisherRxInvokerImpl
implements PublisherRxInvoker {
    private final ClientInvocationBuilder builder;

    public PublisherRxInvokerImpl(ClientInvocationBuilder builder) {
        this.builder = builder;
    }

    protected abstract <T> Publisher<T> toPublisher(CompletionStage<T> var1);

    private <T> Publisher<T> mkPublisher(String method, Entity<?> entity, Function<ClientInvocation, Publisher<T>> mkPublisher) {
        ClientInvocation invocation = this.builder.createClientInvocation(this.builder.invocation);
        invocation.setMethod(method);
        invocation.setEntity(entity);
        return mkPublisher.apply(invocation);
    }

    private Publisher<Response> mkPublisher(String method, Entity<?> entity) {
        return this.mkPublisher(method, entity, (ClientInvocation invocation) -> invocation.reactive().map(ClientInvocation.ReactiveInvocation::submit).orElseGet(() -> this.toPublisher(invocation.submitCF())));
    }

    private <T> Publisher<T> mkPublisher(String method, Entity<?> entity, Class<T> responseType) {
        return this.mkPublisher(method, entity, (ClientInvocation invocation) -> invocation.reactive().map(r -> r.submit(responseType)).orElseGet(() -> this.toPublisher(invocation.submitCF(responseType))));
    }

    private <T> Publisher<T> mkPublisher(String method, Entity<?> entity, GenericType<T> responseType) {
        return this.mkPublisher(method, entity, (ClientInvocation invocation) -> invocation.reactive().map(r -> r.submit(responseType)).orElseGet(() -> this.toPublisher(invocation.submitCF(responseType))));
    }

    @Override
    public Publisher<Response> get() {
        return this.mkPublisher("GET", null);
    }

    @Override
    public <T> Publisher<T> get(Class<T> responseType) {
        return this.mkPublisher("GET", null, responseType);
    }

    @Override
    public <T> Publisher<T> get(GenericType<T> responseType) {
        return this.mkPublisher("GET", null, responseType);
    }

    @Override
    public Publisher<Response> put(Entity<?> entity) {
        return this.mkPublisher("PUT", entity);
    }

    @Override
    public <T> Publisher<T> put(Entity<?> entity, Class<T> clazz) {
        return this.mkPublisher("PUT", entity, clazz);
    }

    @Override
    public <T> Publisher<T> put(Entity<?> entity, GenericType<T> type) {
        return this.mkPublisher("PUT", entity, type);
    }

    @Override
    public Publisher<Response> post(Entity<?> entity) {
        return this.mkPublisher("POST", entity);
    }

    @Override
    public <T> Publisher<T> post(Entity<?> entity, Class<T> clazz) {
        return this.mkPublisher("POST", entity, clazz);
    }

    @Override
    public <T> Publisher<T> post(Entity<?> entity, GenericType<T> type) {
        return this.mkPublisher("POST", entity, type);
    }

    @Override
    public Publisher<Response> delete() {
        return this.mkPublisher("DELETE", null);
    }

    @Override
    public <T> Publisher<T> delete(Class<T> responseType) {
        return this.mkPublisher("DELETE", null, responseType);
    }

    @Override
    public <T> Publisher<T> delete(GenericType<T> responseType) {
        return this.mkPublisher("DELETE", null, responseType);
    }

    @Override
    public Publisher<Response> head() {
        return this.mkPublisher("HEAD", null);
    }

    @Override
    public Publisher<Response> options() {
        return this.mkPublisher("OPTIONS", null);
    }

    @Override
    public <T> Publisher<T> options(Class<T> responseType) {
        return this.mkPublisher("OPTIONS", null, responseType);
    }

    @Override
    public <T> Publisher<T> options(GenericType<T> responseType) {
        return this.mkPublisher("OPTIONS", null, responseType);
    }

    @Override
    public Publisher<Response> trace() {
        return this.method("TRACE");
    }

    @Override
    public <T> Publisher<T> trace(Class<T> responseType) {
        return this.method("TRACE", (Class)responseType);
    }

    @Override
    public <T> Publisher<T> trace(GenericType<T> responseType) {
        return this.method("TRACE", (GenericType)responseType);
    }

    @Override
    public Publisher<Response> method(String name) {
        return this.mkPublisher(name, null);
    }

    @Override
    public <T> Publisher<T> method(String name, Class<T> responseType) {
        return this.mkPublisher(name, null, responseType);
    }

    @Override
    public <T> Publisher<T> method(String name, GenericType<T> responseType) {
        return this.mkPublisher(name, null, responseType);
    }

    @Override
    public Publisher<Response> method(String name, Entity<?> entity) {
        return this.mkPublisher(name, entity);
    }

    @Override
    public <T> Publisher<T> method(String name, Entity<?> entity, Class<T> responseType) {
        return this.mkPublisher(name, entity, responseType);
    }

    @Override
    public <T> Publisher<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
        return this.mkPublisher(name, entity, responseType);
    }
}

