/*
 * Decompiled with CFR 0.152.
 */
package com.chronapp.porter.upload;

import com.chronapp.porter.common.ChronappException;
import com.chronapp.porter.common.Row;
import com.chronapp.porter.config.ClientConfig;
import com.chronapp.porter.upload.UploadDataHandler;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;

public class DataFetcher {
    private static final int ABS_MAX_LIMIT = 10000;
    private final ClientConfig config;
    private final UploadDataHandler uploader;
    private final String select;

    public DataFetcher(ClientConfig config, UploadDataHandler uploader, String table, UUID uuid) throws ChronappException {
        this.config = config;
        this.uploader = uploader;
        this.select = table;
        this.fetchAndUpload(uuid);
    }

    private void fetchAndUpload(UUID uuid) throws ChronappException {
        ArrayList<Row> data = new ArrayList<Row>();
        try (Connection connection = DriverManager.getConnection(this.config.getJdbcurl());
             Statement statement = connection.createStatement();){
            ResultSet r = statement.executeQuery(this.select);
            while (r.next()) {
                ResultSetMetaData metaData = r.getMetaData();
                int columnCount = metaData.getColumnCount();
                data.add(new Row(DataFetcher.extractColumns(columnCount, r)));
                if (data.size() % this.getMaxRows() != 0) continue;
                this.uploader.handle(data, uuid);
                data.clear();
            }
            this.uploader.handle(data, uuid);
            data.clear();
            r.close();
        }
        catch (SQLException e) {
            throw new ChronappException("DataFetcher could not load Data", e, uuid, this.config.getDescription(), null);
        }
    }

    private static HashMap<String, String> extractColumns(int columnCount, ResultSet r) throws SQLException {
        HashMap<String, String> columns = new HashMap<String, String>();
        for (int i = 1; i <= columnCount; ++i) {
            String value = r.getString(i);
            String name = r.getMetaData().getColumnName(i).toLowerCase(Locale.GERMAN);
            if (value != null) {
                columns.put(name, value.trim());
                continue;
            }
            columns.put(name, null);
        }
        return columns;
    }

    private int getMaxRows() {
        return Math.min(10000, this.config.getMaxRows());
    }
}

